﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7_SDK;
using WinfootDefaultPerformancePlugin.Controls.Strategy;

namespace WinfootDefaultPerformancePlugin.Controls
{
    public partial class MaxRequestThreads : UserControl, ICorrespondenceOS, IControl
    {

        private MaxRequestThreadsController maxRequestThreadsController;

        public MaxRequestThreads()
        {
            InitializeComponent();
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                 
#if DEBUG
                                           OS.WindowsVista_SP2,
                                           OS.WindowsSeven
#endif
                                       };
            
        }
        private void groupBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                UserHelp userHelp = new UserHelp(new Uri(@"http://www.migiside.net/wiki/doku.php?id=plugin:performance:maxrequestthreads"));
                userHelp.Show();
            }
        }

        public void SetMaxRequestThreadValue(int i)
        {
            numericUpDown1.Value = Convert.ToDecimal(i);
        }

        public int GetMaxRequestThreadValue()
        {
            return Convert.ToInt32(numericUpDown1.Value);
        }

        #region IControl メンバ

        public void Apply()
        {
            maxRequestThreadsController.Write();
        }

        public List<WFRegistry> BackUp()
        {
            return maxRequestThreadsController.BackUp();
        }

        #endregion

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList
        {
            get; set;
        }

        #endregion

        private void MaxRequestThreads_Load(object sender, EventArgs e)
        {
            WFUtillity wfUtillity = new WFUtillity();
            maxRequestThreadsController = new MaxRequestThreadsController(this,
                                                                                    (IMaxRequestThreadsStrategy)
                                                                                    wfUtillity.GetCorrespondenceInstance
                                                                                        (new List<ICorrespondenceOS>
                                                                                             {
                                                                                                 new MaxRequestThreadsDefaultStrategy()
                                                                                             }));
            maxRequestThreadsController.Read();
        }
    }
}
